<?php
header('Content-Type: image/png');

$number        = isset($_GET['number'])      ? htmlspecialchars($_GET['number'])      : '01986-343907';
$transactionId = isset($_GET['transaction']) ? htmlspecialchars($_GET['transaction']) : '730MGQGC';
$amount        = isset($_GET['amount'])      ? htmlspecialchars($_GET['amount'])      : '500';
$charge        = isset($_GET['charge'])      ? htmlspecialchars($_GET['charge'])      : '';
$total         = isset($_GET['total'])       ? htmlspecialchars($_GET['total'])       : '';

date_default_timezone_set('Asia/Dhaka');

/*** <-- Antik Developed --> ***/

$timeNow = date('h:i A');
$dateNow = date('d F Y');
$time    = "$dateNow, $timeNow";
$timee = "$timeNow";

$background = imagecreatefromjpeg('ss.jpg'); // ensure file exists
$grey  = imagecolorallocate($background, 128, 128, 128);
$white = imagecolorallocate($background, 235, 235, 235);

$Antik        = __DIR__ . '/roboto.ttf';
$fontSize     = 45;
$fontSizeBold = 45;
$trim         = 65;

$textStyles = [
    'number'        => ['y' => 1500, 'size' => $fontSizeBold, 'font' => $Antik, 'color' => $grey],  // center
    'transactionId' => ['y' => 1905, 'size' => $fontSize,     'font' => $Antik, 'color' => $grey],  // center
    'amount'        => ['y' => 1695, 'size' => $fontSize,     'font' => $Antik, 'color' => $grey],  // center
    'charge'        => ['x' => 160, 'y' => 150, 'size' => $fontSize, 'font' => $Antik, 'color' => $grey], // right
    'total'         => ['x' => 1630, 'y' => 1620, 'size' => $fontSize, 'font' => $Antik, 'color' => $grey], // right
    'time'          => ['y' => 2100, 'size' => $fontSize,     'font' => $Antik, 'color' => $grey],  // center
    'timee'       => ['x' => 280,  'y' => 86,  'size' => 36, 'font' => $Antik, 'color' => $white],  // right
];

// ---------- Helper Functions ----------
function getTextWidth($size, $font, $text) {
    $bbox = imagettfbbox($size, 0, $font, $text);
    $xs = [$bbox[0], $bbox[2], $bbox[4], $bbox[6]];
    return max($xs) - min($xs);
}

function getRightAlignedX($text, $size, $font, $rightX) {
    $textWidth = getTextWidth($size, $font, $text);
    return (int) round($rightX - $textWidth);
}

function getCenteredX($text, $size, $font, $leftX, $rightX) {
    $textWidth = getTextWidth($size, $font, $text);
    $boxWidth  = $rightX - $leftX;
    return (int) round($leftX + ($boxWidth - $textWidth) / 2);
}

// ---------- Draw ----------
$imgWidth = imagesx($background);
$centerLeft  = 0;
$centerRight = $imgWidth;

foreach ($textStyles as $key => $style) {
    $text = $$key;

    // এই চারটা key সেন্টার হবে
    if (in_array($key, ['number', 'transactionId', 'amount', 'time'])) {
        $x = getCenteredX($text, $style['size'], $style['font'], $centerLeft, $centerRight);
    } else {
        $x = isset($style['x'])
            ? getRightAlignedX($text, $style['size'], $style['font'], $style['x'])
            : getCenteredX($text, $style['size'], $style['font'], $centerLeft, $centerRight);
    }

    imagettftext(
        $background,
        $style['size'],
        0,
        $x,
        $style['y'],
        $style['color'],
        $style['font'],
        $text
    );
}

// ---------- Output ----------
imagepng($background);
imagedestroy($background);
?>